-- MySQL dump 10.9
--
-- Host: localhost    Database: Sistema
-- ------------------------------------------------------
-- Server version	4.1.14-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `Sistema`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `Sistema` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `Sistema`;

--
-- Table structure for table `acompanhantes_inquilino`
--

DROP TABLE IF EXISTS `acompanhantes_inquilino`;
CREATE TABLE `acompanhantes_inquilino` (
  `id_acompanhante` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `id_inquilino` int(10) NOT NULL default '0',
  `nome_acompanhante` varchar(150) collate latin1_general_ci NOT NULL default '',
  `idade_acompanhante` int(3) NOT NULL default '0',
  `grau_acompanhante` varchar(20) collate latin1_general_ci default NULL,
  PRIMARY KEY  (`id_acompanhante`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `anuncios`
--

DROP TABLE IF EXISTS `anuncios`;
CREATE TABLE `anuncios` (
  `id_anuncio` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `data_anuncio` date NOT NULL default '0000-00-00',
  `veiculo_anuncio` varchar(100) collate latin1_general_ci NOT NULL default '',
  PRIMARY KEY  (`id_anuncio`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `anuncios_temp`
--

DROP TABLE IF EXISTS `anuncios_temp`;
CREATE TABLE `anuncios_temp` (
  `id_anuncio_temp` int(10) NOT NULL auto_increment,
  `sid` varchar(200) collate latin1_general_ci NOT NULL default '',
  `cod` varchar(50) collate latin1_general_ci NOT NULL default '',
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `p_data` date NOT NULL default '0000-00-00',
  `anuncio` int(11) default NULL,
  PRIMARY KEY  (`id_anuncio_temp`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `area`
--

DROP TABLE IF EXISTS `area`;
CREATE TABLE `area` (
  `area_id` int(10) unsigned NOT NULL auto_increment,
  `area_nome` longtext collate latin1_general_ci,
  `area_descricao` longtext collate latin1_general_ci,
  `area_parametro` varchar(50) collate latin1_general_ci default NULL,
  PRIMARY KEY  (`area_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `ata_chaves`
--

DROP TABLE IF EXISTS `ata_chaves`;
CREATE TABLE `ata_chaves` (
  `id_ata` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `cod_imovel` int(10) NOT NULL default '0',
  `data_ata` date NOT NULL default '0000-00-00',
  `hora_ata` time NOT NULL default '00:00:00',
  `nome_ata` varchar(100) collate latin1_general_ci NOT NULL default '',
  `telefone_ata` varchar(20) collate latin1_general_ci NOT NULL default '',
  `data_status_ata` date NOT NULL default '0000-00-00',
  `hora_status_ata` time NOT NULL default '00:00:00',
  `status_ata` varchar(20) collate latin1_general_ci NOT NULL default '',
  PRIMARY KEY  (`id_ata`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `atendimento`
--

DROP TABLE IF EXISTS `atendimento`;
CREATE TABLE `atendimento` (
  `a_cod` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `a_corretor` int(5) NOT NULL default '0',
  `a_data_venda` datetime NOT NULL default '0000-00-00 00:00:00',
  `a_vendas` char(1) NOT NULL default '',
  `a_locacao` char(1) NOT NULL default '',
  `a_data_locacao` datetime NOT NULL default '0000-00-00 00:00:00',
  `a_telefone` char(1) NOT NULL default '',
  `a_data_telefone` datetime NOT NULL default '0000-00-00 00:00:00',
  `a_email` char(1) character set utf8 NOT NULL default '',
  `a_data_email` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`a_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `atualizacao_historico`
--

DROP TABLE IF EXISTS `atualizacao_historico`;
CREATE TABLE `atualizacao_historico` (
  `ah_cod` int(11) NOT NULL auto_increment,
  `ah_imobiliaria` int(11) default NULL,
  `ah_referencia` varchar(11) default NULL,
  `ah_data_hora` datetime default NULL,
  `ah_imagens` int(11) default '0',
  `ah_apagado` char(1) default NULL,
  PRIMARY KEY  (`ah_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `atualizacoes`
--

DROP TABLE IF EXISTS `atualizacoes`;
CREATE TABLE `atualizacoes` (
  `a_id` int(11) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `a_cod_user` int(11) default NULL,
  `a_imovel` varchar(20) collate latin1_general_ci default NULL,
  `a_ref` varchar(10) collate latin1_general_ci NOT NULL default '',
  `a_anuncio` int(10) NOT NULL default '0',
  `a_acao` varchar(30) collate latin1_general_ci default NULL,
  `a_data` date default NULL,
  `a_hora` varchar(11) collate latin1_general_ci default NULL,
  PRIMARY KEY  (`a_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `avaliados`
--

DROP TABLE IF EXISTS `avaliados`;
CREATE TABLE `avaliados` (
  `id_avaliacao` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `cod_imovel` int(10) NOT NULL default '0',
  `data` date NOT NULL default '0000-00-00',
  `user` int(10) NOT NULL default '0',
  `total_diarias` varchar(30) collate latin1_general_ci NOT NULL default '',
  PRIMARY KEY  (`id_avaliacao`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `bairros`
--

DROP TABLE IF EXISTS `bairros`;
CREATE TABLE `bairros` (
  `b_id` int(11) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `b_bairro` varchar(50) collate latin1_general_ci default NULL,
  PRIMARY KEY  (`b_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `bancos`
--

DROP TABLE IF EXISTS `bancos`;
CREATE TABLE `bancos` (
  `b_cod` int(5) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `b_nome` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`b_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `banners_site`
--

DROP TABLE IF EXISTS `banners_site`;
CREATE TABLE `banners_site` (
  `b_cod` int(11) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `b_nome` varchar(50) NOT NULL default '',
  `b_link` text NOT NULL,
  `b_target` varchar(25) NOT NULL default '',
  `b_img` varchar(100) NOT NULL default '',
  `b_height` int(4) default NULL,
  `b_width` int(4) default NULL,
  `b_setor` varchar(40) default NULL,
  `b_ativo` char(3) default NULL,
  `b_ordem` int(3) default NULL,
  `b_tipo_arquivo` varchar(20) NOT NULL default '',
  `b_views` int(10) NOT NULL default '0',
  `b_clicks` int(10) NOT NULL default '0',
  PRIMARY KEY  (`b_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `boleto`
--

DROP TABLE IF EXISTS `boleto`;
CREATE TABLE `boleto` (
  `codigo` int(10) NOT NULL auto_increment,
  `sacado` varchar(255) NOT NULL default '',
  `nrdoc` varchar(11) NOT NULL default '',
  `dt_vcto` date NOT NULL default '0000-00-00',
  `valor` double NOT NULL default '0',
  `d_prazo` int(11) NOT NULL default '0',
  `taxa` double NOT NULL default '0',
  `end1` varchar(50) NOT NULL default '',
  `end2` varchar(50) NOT NULL default '',
  `demo1` varchar(255) NOT NULL default '',
  `demo2` varchar(255) NOT NULL default '',
  `demo3` varchar(255) NOT NULL default '',
  `inst1` varchar(255) NOT NULL default '',
  `inst2` varchar(255) NOT NULL default '',
  `inst3` varchar(255) NOT NULL default '',
  `inst4` varchar(255) NOT NULL default '',
  `razao` varchar(50) NOT NULL default '',
  `razao_cnpj` varchar(50) NOT NULL default '',
  `razao_end` varchar(50) NOT NULL default '',
  `razao_local` varchar(50) NOT NULL default '',
  `url_boleto` text NOT NULL,
  `status` varchar(7) default NULL,
  `loc_deletada` char(1) NOT NULL default 'N',
  `bol_baixado` char(1) NOT NULL default 'N',
  `dt_baixa` date NOT NULL default '0000-00-00',
  `dt_pgto` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`codigo`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `bp_messages`
--

DROP TABLE IF EXISTS `bp_messages`;
CREATE TABLE `bp_messages` (
  `id` int(11) NOT NULL auto_increment,
  `id_send` int(11) NOT NULL default '0',
  `id_receive` int(11) NOT NULL default '0',
  `name` varchar(50) collate latin1_general_ci NOT NULL default '',
  `message` varchar(255) collate latin1_general_ci NOT NULL default '',
  `time` time NOT NULL default '00:00:00',
  `lifetime` varchar(25) collate latin1_general_ci NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `bp_users`
--

DROP TABLE IF EXISTS `bp_users`;
CREATE TABLE `bp_users` (
  `id` int(11) NOT NULL auto_increment,
  `status` int(1) NOT NULL default '1',
  `name` varchar(50) collate latin1_general_ci NOT NULL default '',
  `photo` varchar(25) collate latin1_general_ci default NULL,
  `lifetime` varchar(25) collate latin1_general_ci NOT NULL default '',
  `ip` varchar(25) collate latin1_general_ci NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `caracteristicas`
--

DROP TABLE IF EXISTS `caracteristicas`;
CREATE TABLE `caracteristicas` (
  `c_id` int(11) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `c_caracteristica` varchar(100) collate latin1_general_ci default NULL,
  PRIMARY KEY  (`c_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `carrinho`
--

DROP TABLE IF EXISTS `carrinho`;
CREATE TABLE `carrinho` (
  `ca_usu` varchar(100) NOT NULL default '0',
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `ca_imovel` varchar(10) NOT NULL default '0',
  `ca_data` datetime NOT NULL default '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `clientes`
--

DROP TABLE IF EXISTS `clientes`;
CREATE TABLE `clientes` (
  `c_cod` int(11) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `c_tipo_pessoa` char(1) NOT NULL default '',
  `c_nome` varchar(200) NOT NULL default '',
  `c_cpf` varchar(18) NOT NULL default '',
  `c_rg` varchar(20) NOT NULL default '',
  `c_civil` varchar(20) NOT NULL default '',
  `c_origem` varchar(40) NOT NULL default '',
  `c_end` varchar(200) NOT NULL default '',
  `c_bairro` varchar(50) default NULL,
  `c_cep` varchar(8) NOT NULL default '',
  `c_cidade` varchar(100) NOT NULL default '',
  `c_estado` char(2) NOT NULL default '',
  `c_origem_com` varchar(40) NOT NULL default '',
  `c_end_com` varchar(200) NOT NULL default '',
  `c_bairro_com` varchar(50) NOT NULL default '',
  `c_cep_com` varchar(8) NOT NULL default '',
  `c_cidade_com` varchar(100) NOT NULL default '',
  `c_estado_com` char(2) NOT NULL default '',
  `c_tel` varchar(50) NOT NULL default '',
  `c_cel` varchar(20) default NULL,
  `c_fax` varchar(20) default NULL,
  `c_email` varchar(200) default NULL,
  `c_nasc` date default NULL,
  `c_desde` date NOT NULL default '0000-00-00',
  `c_prestador` varchar(30) NOT NULL default '',
  `c_tipo` varchar(50) NOT NULL default '',
  `c_obs` text,
  `c_conta` text,
  `c_prof` varchar(50) default NULL,
  `c_repre` longtext NOT NULL,
  `c_repre2` longtext NOT NULL,
  `c_banco` varchar(50) default NULL,
  `c_conjuge` varchar(200) NOT NULL default '',
  `c_rg_conjuge` varchar(20) NOT NULL default '',
  `c_cpf_conjuge` varchar(18) NOT NULL default '',
  `c_tel2` varchar(20) NOT NULL default '',
  `c_cel2` varchar(20) NOT NULL default '',
  `c_tel_com` varchar(20) NOT NULL default '',
  `c_fax_com` varchar(20) NOT NULL default '',
  `c_email_com` varchar(200) NOT NULL default '',
  `c_prestador2` varchar(50) NOT NULL default '',
  `c_tipo2` varchar(50) NOT NULL default '',
  `c_garantia` longtext,
  PRIMARY KEY  (`c_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `comercios`
--

DROP TABLE IF EXISTS `comercios`;
CREATE TABLE `comercios` (
  `id_comercio` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `tipo_comercio` int(10) NOT NULL default '0',
  `estado_comercio` int(10) NOT NULL default '0',
  `cidade_comercio` int(10) NOT NULL default '0',
  `bairro_comercio` int(10) NOT NULL default '0',
  `nome_comercio` varchar(150) NOT NULL default '',
  `logradouro_comercio` varchar(30) NOT NULL default '',
  `endereco_comercio` varchar(150) NOT NULL default '',
  `numero_comercio` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`id_comercio`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `comissoes`
--

DROP TABLE IF EXISTS `comissoes`;
CREATE TABLE `comissoes` (
  `id_comissao` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `indicador` double NOT NULL default '0',
  `vendedor` double NOT NULL default '0',
  `data_comissao` date NOT NULL default '0000-00-00',
  `hora_comissao` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`id_comissao`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `computador`
--

DROP TABLE IF EXISTS `computador`;
CREATE TABLE `computador` (
  `computador_id` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `computador_nome` varchar(100) collate latin1_general_ci default NULL,
  `computador_codigo` varchar(8) collate latin1_general_ci default NULL,
  `computador_cookie` varchar(32) collate latin1_general_ci default NULL,
  `computador_ativo` char(1) collate latin1_general_ci default NULL,
  `computador_confirmado` char(1) collate latin1_general_ci default NULL,
  PRIMARY KEY  (`computador_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `contas`
--

DROP TABLE IF EXISTS `contas`;
CREATE TABLE `contas` (
  `co_cod` bigint(15) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `co_cliente` int(11) default '0',
  `co_cat` varchar(20) NOT NULL default '',
  `co_imovel` int(11) default NULL,
  `co_desc` text,
  `co_tipo` varchar(20) NOT NULL default '',
  `co_data` date NOT NULL default '0000-00-00',
  `co_status` varchar(20) NOT NULL default 'Pendente',
  `co_valor` double(10,2) NOT NULL default '0.00',
  `co_locacao` int(11) default NULL,
  `co_data_status` date NOT NULL default '0000-00-00',
  `co_usuario` varchar(100) NOT NULL default '0',
  `co_forma` varchar(20) NOT NULL default 'Depósito',
  `co_boleto` varchar(11) NOT NULL default '',
  `co_conciliado` char(1) NOT NULL default 'N',
  `co_usuario_status` varchar(100) default NULL,
  `co_fixar` char(3) NOT NULL default 'ok',
  `co_tipo_user` char(1) NOT NULL default '',
  `co_impressao` char(1) NOT NULL default '0',
  `co_verificacao` char(1) NOT NULL default '0',
  `co_despesa` varchar(30) NOT NULL default '',
  `co_tipo_despesa` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`co_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `depositos`
--

DROP TABLE IF EXISTS `depositos`;
CREATE TABLE `depositos` (
  `d_cod` int(5) unsigned NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `d_loc` int(5) unsigned NOT NULL default '0',
  `d_desc` text,
  `d_valor` double(10,2) default NULL,
  `d_data` date default NULL,
  `d_saldo` double(10,2) default NULL,
  `d_imovel` int(5) unsigned default NULL,
  PRIMARY KEY  (`d_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `despesas`
--

DROP TABLE IF EXISTS `despesas`;
CREATE TABLE `despesas` (
  `de_cod` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `de_imovel` int(11) NOT NULL default '0',
  `de_locacao` int(11) NOT NULL default '0',
  `de_diarista` int(11) NOT NULL default '0',
  `de_valor` double(10,2) NOT NULL default '0.00',
  `de_data` date NOT NULL default '0000-00-00',
  `de_desc` text,
  `de_status` varchar(30) NOT NULL default 'A PAGAR',
  `de_tipo` int(10) NOT NULL default '0',
  `de_recibo` int(10) NOT NULL default '0',
  `de_dtrecibo` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`de_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `destaque`
--

DROP TABLE IF EXISTS `destaque`;
CREATE TABLE `destaque` (
  `cod_d` varchar(4) NOT NULL default '',
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `data` date NOT NULL default '0000-00-00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `dicas`
--

DROP TABLE IF EXISTS `dicas`;
CREATE TABLE `dicas` (
  `d_cod` int(11) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `d_tipo` varchar(50) NOT NULL default '',
  `d_titulo` varchar(200) NOT NULL default '',
  `d_data` date default NULL,
  `d_autor` varchar(100) NOT NULL default '',
  `d_texto` text,
  `d_img` varchar(30) NOT NULL default '',
  PRIMARY KEY  (`d_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `doc`
--

DROP TABLE IF EXISTS `doc`;
CREATE TABLE `doc` (
  `d_id` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `d_txt` longtext collate latin1_general_ci NOT NULL,
  `d_nome` varchar(200) collate latin1_general_ci NOT NULL default '',
  `d_data` date NOT NULL default '0000-00-00',
  `d_tipo_contrato` char(1) collate latin1_general_ci NOT NULL default '',
  `d_contrato` varchar(30) collate latin1_general_ci default NULL,
  `d_cod` int(10) NOT NULL default '0',
  PRIMARY KEY  (`d_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `doc_copia`
--

DROP TABLE IF EXISTS `doc_copia`;
CREATE TABLE `doc_copia` (
  `d_id` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `d_txt` longtext collate latin1_general_ci NOT NULL,
  `d_nome` varchar(200) collate latin1_general_ci NOT NULL default '',
  `d_data` date NOT NULL default '0000-00-00',
  `d_tipo_contrato` char(1) collate latin1_general_ci NOT NULL default '',
  `d_contrato` varchar(30) collate latin1_general_ci default NULL,
  `d_cod` int(10) NOT NULL default '0',
  PRIMARY KEY  (`d_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `doc_copia2`
--

DROP TABLE IF EXISTS `doc_copia2`;
CREATE TABLE `doc_copia2` (
  `d_id` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `d_txt` longtext collate latin1_general_ci NOT NULL,
  `d_nome` varchar(200) collate latin1_general_ci NOT NULL default '',
  `d_data` date NOT NULL default '0000-00-00',
  `d_tipo_contrato` char(1) collate latin1_general_ci NOT NULL default '',
  `d_contrato` varchar(30) collate latin1_general_ci default NULL,
  `d_cod` int(10) NOT NULL default '0',
  PRIMARY KEY  (`d_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `docs_padrao`
--

DROP TABLE IF EXISTS `docs_padrao`;
CREATE TABLE `docs_padrao` (
  `dp_id` int(10) NOT NULL auto_increment,
  `dp_txt` longtext NOT NULL,
  `dp_nome` varchar(200) NOT NULL default '',
  `dp_cod` int(10) NOT NULL default '0',
  PRIMARY KEY  (`dp_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `feriados`
--

DROP TABLE IF EXISTS `feriados`;
CREATE TABLE `feriados` (
  `id_feriado` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `dia` char(2) collate latin1_general_ci NOT NULL default '',
  `mes` char(2) collate latin1_general_ci NOT NULL default '',
  `nome` varchar(100) collate latin1_general_ci NOT NULL default '',
  PRIMARY KEY  (`id_feriado`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `ficha_inquilinos`
--

DROP TABLE IF EXISTS `ficha_inquilinos`;
CREATE TABLE `ficha_inquilinos` (
  `id_inquilino` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `con_ref_inquilino` text collate latin1_general_ci NOT NULL,
  `ap_inquilino` varchar(20) collate latin1_general_ci NOT NULL default '',
  `prop_inquilino` longtext collate latin1_general_ci NOT NULL,
  `resp_inquilino` varchar(150) collate latin1_general_ci NOT NULL default '',
  `fone_inquilino` varchar(20) collate latin1_general_ci NOT NULL default '',
  `celular_inquilino` varchar(20) collate latin1_general_ci default NULL,
  `rg_inquilino` varchar(15) collate latin1_general_ci NOT NULL default '',
  `cpf_inquilino` varchar(11) collate latin1_general_ci NOT NULL default '',
  `data_nasc_inquilino` date NOT NULL default '0000-00-00',
  `cidade_inquilino` varchar(150) collate latin1_general_ci NOT NULL default '',
  `estado_inquilino` char(2) collate latin1_general_ci NOT NULL default '',
  `entrada_inquilino` date NOT NULL default '0000-00-00',
  `saida_inquilino` date NOT NULL default '0000-00-00',
  `data_inquilino` date NOT NULL default '0000-00-00',
  `comentarios_inquilino` longtext collate latin1_general_ci,
  PRIMARY KEY  (`id_inquilino`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `finalidade`
--

DROP TABLE IF EXISTS `finalidade`;
CREATE TABLE `finalidade` (
  `f_cod` int(11) NOT NULL auto_increment,
  `f_nome` varchar(100) collate latin1_general_ci NOT NULL default '',
  PRIMARY KEY  (`f_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `fotos`
--

DROP TABLE IF EXISTS `fotos`;
CREATE TABLE `fotos` (
  `idfoto` int(11) NOT NULL auto_increment,
  `cod` int(11) NOT NULL default '0',
  `ref` varchar(10) default NULL,
  `pasta` varchar(50) default NULL,
  `sequencia` char(2) default NULL,
  `site` char(1) default 'N',
  PRIMARY KEY  (`idfoto`,`cod`),
  KEY `AI_idfoto` (`idfoto`),
  KEY `cod` (`cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `imoveis_anuncio`
--

DROP TABLE IF EXISTS `imoveis_anuncio`;
CREATE TABLE `imoveis_anuncio` (
  `id_anuncio_imovel` int(10) NOT NULL auto_increment,
  `cod_imovel` int(10) NOT NULL default '0',
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `id_anuncio` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id_anuncio_imovel`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `imoveis_temp`
--

DROP TABLE IF EXISTS `imoveis_temp`;
CREATE TABLE `imoveis_temp` (
  `sid` varchar(200) NOT NULL default '',
  `cod` varchar(50) NOT NULL default '',
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `p_data` date NOT NULL default '0000-00-00',
  `interessado` int(11) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `interessados`
--

DROP TABLE IF EXISTS `interessados`;
CREATE TABLE `interessados` (
  `i_cod` int(5) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `i_nome` varchar(200) NOT NULL default '',
  `i_tel` varchar(50) NOT NULL default '',
  `i_email` varchar(200) default NULL,
  `i_obs` text,
  `i_ref` varchar(10) default NULL,
  `i_tipo` varchar(50) NOT NULL default '',
  `i_data` datetime NOT NULL default '0000-00-00 00:00:00',
  `i_status` varchar(30) default NULL,
  `i_data_status` datetime NOT NULL default '0000-00-00 00:00:00',
  `i_corretor` varchar(100) default NULL,
  `i_libera` char(1) NOT NULL default 'n',
  `i_controle` char(1) NOT NULL default '',
  PRIMARY KEY  (`i_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `listas`
--

DROP TABLE IF EXISTS `listas`;
CREATE TABLE `listas` (
  `li_cod` int(5) unsigned NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `li_sid` varchar(200) NOT NULL default '',
  `li_interessado` int(11) NOT NULL default '0',
  `li_data` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`li_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `locacao`
--

DROP TABLE IF EXISTS `locacao`;
CREATE TABLE `locacao` (
  `l_cliente` int(5) NOT NULL default '0',
  `l_imovel` varchar(10) NOT NULL default '',
  `l_data_ent` date NOT NULL default '0000-00-00',
  `l_data_sai` date NOT NULL default '0000-00-00',
  `l_total` double(10,2) NOT NULL default '0.00',
  `l_pagto` text,
  `l_limpeza` double(10,2) default NULL,
  `l_cod` int(5) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `l_historico` text,
  `l_comissao` double(6,2) default NULL,
  `l_desp` double(6,2) default NULL,
  `l_saldo` double(10,2) default NULL,
  `l_data` date default NULL,
  `l_outros` double(6,2) default NULL,
  `l_tv` double(10,2) default NULL,
  `l_usuario` varchar(100) default NULL,
  `l_n_contrato` varchar(30) NOT NULL default '',
  `l_tipo_contrato` varchar(30) NOT NULL default '',
  `l_modelo` int(10) NOT NULL default '0',
  `l_vigencia` varchar(30) NOT NULL default '',
  `l_venc_contrato` date NOT NULL default '0000-00-00',
  `l_venc_aluguel` date NOT NULL default '0000-00-00',
  `l_tolerancia` varchar(5) NOT NULL default '',
  `l_multa` varchar(20) default NULL,
  `l_bonificacao` varchar(5) NOT NULL default '',
  `l_reajustes` varchar(5) NOT NULL default '',
  `l_indice` varchar(30) NOT NULL default '',
  `l_ultimo_reajuste` date NOT NULL default '0000-00-00',
  `l_proximo_reajuste` date NOT NULL default '0000-00-00',
  `l_fianca` varchar(30) default NULL,
  `l_fiador` varchar(100) NOT NULL default '0',
  `l_testemunha` int(10) NOT NULL default '0',
  `l_testemunha2` int(10) NOT NULL default '0',
  `contadorf` char(2) NOT NULL default '',
  `l_garantia` longtext,
  `l_status` int(1) default '1',
  PRIMARY KEY  (`l_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `login`
--

DROP TABLE IF EXISTS `login`;
CREATE TABLE `login` (
  `email` varchar(200) NOT NULL default '',
  `data_hora` datetime NOT NULL default '0000-00-00 00:00:00',
  `senha` varchar(6) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `logusuarios`
--

DROP TABLE IF EXISTS `logusuarios`;
CREATE TABLE `logusuarios` (
  `l_log` int(11) NOT NULL auto_increment,
  `u_cod` int(2) NOT NULL default '0',
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `u_nome` varchar(200) NOT NULL default '',
  `l_datalog` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`l_log`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `mapa`
--

DROP TABLE IF EXISTS `mapa`;
CREATE TABLE `mapa` (
  `mp_cod` int(11) NOT NULL auto_increment,
  `mp_nome` varchar(100) NOT NULL default '',
  `mp_endereco` varchar(200) NOT NULL default '',
  `mp_latitude` decimal(30,20) NOT NULL default '0.00000000000000000000',
  `mp_longitude` decimal(30,20) NOT NULL default '0.00000000000000000000',
  `mp_tipo` int(11) NOT NULL default '0',
  PRIMARY KEY  (`mp_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `mapa_tipo`
--

DROP TABLE IF EXISTS `mapa_tipo`;
CREATE TABLE `mapa_tipo` (
  `mt_cod` int(11) NOT NULL auto_increment,
  `mt_tipo` varchar(20) NOT NULL default '',
  `mt_imagem` varchar(200) NOT NULL default '',
  `mt_tam_imagem` varchar(30) NOT NULL default '25, 32',
  `mt_tam_sombra` varchar(30) NOT NULL default '25, 32',
  `mt_tam_ancora` varchar(30) NOT NULL default '16, 16',
  `mt_tam_ancora2` varchar(30) NOT NULL default '5, 1',
  PRIMARY KEY  (`mt_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `mensagens`
--

DROP TABLE IF EXISTS `mensagens`;
CREATE TABLE `mensagens` (
  `me_id` int(11) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `me_cod_user_envia` int(11) default NULL,
  `me_cod_user_recebe` int(11) default NULL,
  `me_assunto` varchar(100) collate latin1_general_ci NOT NULL default '',
  `me_texto` longtext collate latin1_general_ci,
  `me_data` date default NULL,
  `me_hora` varchar(8) collate latin1_general_ci default NULL,
  `me_status` int(1) default NULL,
  PRIMARY KEY  (`me_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `muraski`
--

DROP TABLE IF EXISTS `muraski`;
CREATE TABLE `muraski` (
  `cod` int(11) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `ref` varchar(10) NOT NULL default '',
  `tipo` varchar(50) NOT NULL default '',
  `tipo_secundario` varchar(255) NOT NULL default '',
  `metragem` double(10,2) unsigned default NULL,
  `area_averbada` double(10,2) NOT NULL default '0.00',
  `area_terreno` double(10,2) NOT NULL default '0.00',
  `matricula_luz` int(11) NOT NULL default '0',
  `situacao_luz` int(1) NOT NULL default '0',
  `matricula_agua` int(11) NOT NULL default '0',
  `situacao_agua` int(1) NOT NULL default '0',
  `n_quartos` tinyint(3) unsigned default NULL,
  `valor` double(10,2) unsigned default NULL,
  `especificacao` varchar(10) default NULL,
  `suites` tinyint(3) unsigned default NULL,
  `caracteristica` varchar(100) NOT NULL default '',
  `piscina` varchar(7) default NULL,
  `titulo` text NOT NULL,
  `descricao` text NOT NULL,
  `img_peq` varchar(23) default NULL,
  `img_1` varchar(20) default NULL,
  `img_2` varchar(20) default NULL,
  `img_3` varchar(20) default NULL,
  `img_4` varchar(20) default NULL,
  `img_5` varchar(20) default NULL,
  `img_6` varchar(20) default NULL,
  `img_7` varchar(20) default NULL,
  `img_8` varchar(20) default NULL,
  `img_9` varchar(20) default NULL,
  `img_10` varchar(20) default NULL,
  `uf` int(2) NOT NULL default '0',
  `local` varchar(40) default NULL,
  `permuta` varchar(7) default NULL,
  `finalidade` varchar(50) NOT NULL default '',
  `permuta_txt` text,
  `ftxt_1` varchar(50) default NULL,
  `ftxt_2` varchar(50) default NULL,
  `ftxt_3` varchar(50) default NULL,
  `ftxt_4` varchar(50) default NULL,
  `ftxt_5` varchar(50) default NULL,
  `ftxt_6` varchar(50) default NULL,
  `ftxt_7` varchar(50) default NULL,
  `ftxt_8` varchar(50) default NULL,
  `ftxt_9` varchar(50) default NULL,
  `ftxt_10` varchar(50) default NULL,
  `ftxt_11` varchar(50) default NULL,
  `ftxt_12` varchar(50) default NULL,
  `ftxt_13` varchar(50) default NULL,
  `ftxt_14` varchar(50) default NULL,
  `ftxt_15` varchar(50) default NULL,
  `ftxt_16` varchar(50) default NULL,
  `ftxt_17` varchar(50) default NULL,
  `ftxt_18` varchar(50) default NULL,
  `ftxt_19` varchar(50) default NULL,
  `ftxt_20` varchar(50) default NULL,
  `cliente` varchar(100) NOT NULL default '',
  `percentual_prop` varchar(100) NOT NULL default '',
  `matricula` varchar(10) default NULL,
  `cidade_mat` varchar(40) default NULL,
  `cartorio_oficio` varchar(100) NOT NULL default '',
  `lote` varchar(10) NOT NULL default '',
  `quadra` varchar(10) NOT NULL default '',
  `planta` varchar(100) NOT NULL default '',
  `bairro` varchar(100) NOT NULL default '',
  `tipo_logradouro` varchar(10) NOT NULL default '',
  `end` varchar(200) default NULL,
  `numero` varchar(10) NOT NULL default '',
  `cep` varchar(10) NOT NULL default '',
  `averbacao` double(10,2) default NULL,
  `acomod` tinyint(2) NOT NULL default '0',
  `dist_mar` varchar(20) NOT NULL default '',
  `dist_tipo` varchar(40) default NULL,
  `limpeza` double(6,2) default NULL,
  `diaria1` double(10,2) default NULL,
  `diaria2` double(10,2) default NULL,
  `data_inicio` date default NULL,
  `data_fim` date default NULL,
  `datai_renova` date default NULL,
  `dataf_renova` date default NULL,
  `comissao` int(11) NOT NULL default '0',
  `dias` int(5) default NULL,
  `dias_plocacao` varchar(50) NOT NULL default '',
  `contrato` int(10) NOT NULL default '0',
  `renova_simnao` char(1) NOT NULL default '1',
  `opcao_simnao` char(1) NOT NULL default '0',
  `carnaval` double(10,2) default NULL,
  `anonovo` double(10,2) default NULL,
  `feriado` double(10,2) default NULL,
  `coordenadas` longtext NOT NULL,
  `posx` int(6) unsigned default NULL,
  `posy` int(6) unsigned default NULL,
  `tv` double(10,2) default NULL,
  `angariador` varchar(50) NOT NULL default '',
  `zelador` varchar(200) default NULL,
  `tipo_anga` varchar(50) NOT NULL default '',
  `indicador` int(10) NOT NULL default '0',
  `comissao_indicador` varchar(10) NOT NULL default '',
  `comissao_vendedor` varchar(10) NOT NULL default '',
  `diarista` int(10) NOT NULL default '0',
  `comissao_diarista` varchar(10) NOT NULL default '',
  `piscineiro` int(10) NOT NULL default '0',
  `comissao_piscineiro` varchar(10) NOT NULL default '',
  `eletricista` int(10) NOT NULL default '0',
  `comissao_eletricista` varchar(10) NOT NULL default '',
  `encanador` int(10) NOT NULL default '0',
  `comissao_encanador` varchar(10) NOT NULL default '',
  `jardineiro` int(10) NOT NULL default '0',
  `comissao_jardineiro` varchar(10) NOT NULL default '',
  `chaves` text,
  `controle_chave` int(10) NOT NULL default '0',
  `tipo_div` varchar(200) default NULL,
  `valor_oferta` double(20,2) default NULL,
  `relacao_bens` text NOT NULL,
  `data_bens` date default NULL,
  `observacoes` text NOT NULL,
  `disponibilizar` char(1) NOT NULL default '0',
  `disp_rede` char(1) NOT NULL default '0',
  `destaque` char(1) NOT NULL default '0',
  `destaque_padrao` char(1) default '0',
  `lancamento` char(1) default '0',
  `comissao_parceria` varchar(10) NOT NULL default '',
  `contador` char(2) NOT NULL default '',
  `status` char(1) NOT NULL default '0',
  `construtora` varchar(100) NOT NULL default '',
  `idade_imovel` varchar(5) NOT NULL default '',
  `condominio` varchar(100) NOT NULL default '0.00',
  `apto` varchar(10) NOT NULL default '',
  `end_igual` char(1) NOT NULL default '1',
  `end_aproximado` char(1) default '0',
  `tipo_logradouro_mapa` varchar(10) NOT NULL default '',
  `end_mapa` varchar(200) NOT NULL default '',
  `numero_mapa` varchar(10) NOT NULL default '',
  `cep_mapa` varchar(10) default NULL,
  `video` varchar(50) default NULL,
  `origem_video` varchar(25) default NULL,
  `endereco_contrato` longtext NOT NULL,
  `exibir_endereco` char(1) NOT NULL default '0',
  `observacoes2` longtext NOT NULL,
  `observacoes3` longtext NOT NULL,
  `ncoordenadas` varchar(100) NOT NULL default '',
  `calendario` int(1) NOT NULL default '0',
  `tipo_fianca` varchar(40) default NULL,
  PRIMARY KEY  (`cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `muraski_bkp01102019`
--

DROP TABLE IF EXISTS `muraski_bkp01102019`;
CREATE TABLE `muraski_bkp01102019` (
  `cod` int(11) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `ref` varchar(10) NOT NULL default '',
  `tipo` varchar(50) NOT NULL default '',
  `tipo_secundario` varchar(255) NOT NULL default '',
  `metragem` double(10,2) unsigned default NULL,
  `area_averbada` double(10,2) NOT NULL default '0.00',
  `area_terreno` double(10,2) NOT NULL default '0.00',
  `matricula_luz` int(11) NOT NULL default '0',
  `situacao_luz` int(1) NOT NULL default '0',
  `matricula_agua` int(11) NOT NULL default '0',
  `situacao_agua` int(1) NOT NULL default '0',
  `n_quartos` tinyint(3) unsigned default NULL,
  `valor` double(10,2) unsigned default NULL,
  `especificacao` varchar(10) default NULL,
  `suites` tinyint(3) unsigned default NULL,
  `caracteristica` varchar(100) NOT NULL default '',
  `piscina` varchar(7) default NULL,
  `titulo` text NOT NULL,
  `descricao` text NOT NULL,
  `img_peq` varchar(23) default NULL,
  `img_1` varchar(20) default NULL,
  `img_2` varchar(20) default NULL,
  `img_3` varchar(20) default NULL,
  `img_4` varchar(20) default NULL,
  `img_5` varchar(20) default NULL,
  `img_6` varchar(20) default NULL,
  `img_7` varchar(20) default NULL,
  `img_8` varchar(20) default NULL,
  `img_9` varchar(20) default NULL,
  `img_10` varchar(20) default NULL,
  `uf` int(2) NOT NULL default '0',
  `local` varchar(40) default NULL,
  `permuta` varchar(7) default NULL,
  `finalidade` varchar(50) NOT NULL default '',
  `permuta_txt` text,
  `ftxt_1` varchar(50) default NULL,
  `ftxt_2` varchar(50) default NULL,
  `ftxt_3` varchar(50) default NULL,
  `ftxt_4` varchar(50) default NULL,
  `ftxt_5` varchar(50) default NULL,
  `ftxt_6` varchar(50) default NULL,
  `ftxt_7` varchar(50) default NULL,
  `ftxt_8` varchar(50) default NULL,
  `ftxt_9` varchar(50) default NULL,
  `ftxt_10` varchar(50) default NULL,
  `ftxt_11` varchar(50) default NULL,
  `ftxt_12` varchar(50) default NULL,
  `ftxt_13` varchar(50) default NULL,
  `ftxt_14` varchar(50) default NULL,
  `ftxt_15` varchar(50) default NULL,
  `ftxt_16` varchar(50) default NULL,
  `ftxt_17` varchar(50) default NULL,
  `ftxt_18` varchar(50) default NULL,
  `ftxt_19` varchar(50) default NULL,
  `ftxt_20` varchar(50) default NULL,
  `cliente` varchar(100) NOT NULL default '',
  `percentual_prop` varchar(100) NOT NULL default '',
  `matricula` varchar(10) default NULL,
  `cidade_mat` varchar(40) default NULL,
  `cartorio_oficio` varchar(100) NOT NULL default '',
  `lote` varchar(10) NOT NULL default '',
  `quadra` varchar(10) NOT NULL default '',
  `planta` varchar(100) NOT NULL default '',
  `bairro` varchar(100) NOT NULL default '',
  `tipo_logradouro` varchar(10) NOT NULL default '',
  `end` varchar(200) default NULL,
  `numero` varchar(10) NOT NULL default '',
  `cep` varchar(10) NOT NULL default '',
  `averbacao` double(10,2) default NULL,
  `acomod` tinyint(2) NOT NULL default '0',
  `dist_mar` varchar(20) NOT NULL default '',
  `dist_tipo` varchar(40) default NULL,
  `limpeza` double(5,2) default NULL,
  `diaria1` double(10,2) default NULL,
  `diaria2` double(10,2) default NULL,
  `data_inicio` date default NULL,
  `data_fim` date default NULL,
  `datai_renova` date default NULL,
  `dataf_renova` date default NULL,
  `comissao` int(11) NOT NULL default '0',
  `dias` int(5) default NULL,
  `dias_plocacao` varchar(50) NOT NULL default '',
  `contrato` int(10) NOT NULL default '0',
  `renova_simnao` char(1) NOT NULL default '1',
  `opcao_simnao` char(1) NOT NULL default '0',
  `carnaval` double(10,2) default NULL,
  `anonovo` double(10,2) default NULL,
  `feriado` double(10,2) default NULL,
  `coordenadas` longtext NOT NULL,
  `posx` int(6) unsigned default NULL,
  `posy` int(6) unsigned default NULL,
  `tv` double(10,2) default NULL,
  `angariador` varchar(50) NOT NULL default '',
  `zelador` varchar(200) default NULL,
  `tipo_anga` varchar(50) NOT NULL default '',
  `indicador` int(10) NOT NULL default '0',
  `comissao_indicador` varchar(10) NOT NULL default '',
  `comissao_vendedor` varchar(10) NOT NULL default '',
  `diarista` int(10) NOT NULL default '0',
  `comissao_diarista` varchar(10) NOT NULL default '',
  `piscineiro` int(10) NOT NULL default '0',
  `comissao_piscineiro` varchar(10) NOT NULL default '',
  `eletricista` int(10) NOT NULL default '0',
  `comissao_eletricista` varchar(10) NOT NULL default '',
  `encanador` int(10) NOT NULL default '0',
  `comissao_encanador` varchar(10) NOT NULL default '',
  `jardineiro` int(10) NOT NULL default '0',
  `comissao_jardineiro` varchar(10) NOT NULL default '',
  `chaves` text,
  `controle_chave` int(10) NOT NULL default '0',
  `tipo_div` varchar(200) default NULL,
  `valor_oferta` double(20,2) default NULL,
  `relacao_bens` text NOT NULL,
  `data_bens` date default NULL,
  `observacoes` text NOT NULL,
  `disponibilizar` char(1) NOT NULL default '0',
  `disp_rede` char(1) NOT NULL default '0',
  `destaque` char(1) NOT NULL default '0',
  `destaque_padrao` char(1) default '0',
  `lancamento` char(1) default '0',
  `comissao_parceria` varchar(10) NOT NULL default '',
  `contador` char(2) NOT NULL default '',
  `status` char(1) NOT NULL default '0',
  `construtora` varchar(100) NOT NULL default '',
  `idade_imovel` varchar(5) NOT NULL default '',
  `condominio` varchar(100) NOT NULL default '0.00',
  `apto` varchar(10) NOT NULL default '',
  `end_igual` char(1) NOT NULL default '1',
  `end_aproximado` char(1) default '0',
  `tipo_logradouro_mapa` varchar(10) NOT NULL default '',
  `end_mapa` varchar(200) NOT NULL default '',
  `numero_mapa` varchar(10) NOT NULL default '',
  `cep_mapa` varchar(10) default NULL,
  `video` varchar(50) default NULL,
  `origem_video` varchar(25) default NULL,
  `endereco_contrato` longtext NOT NULL,
  `exibir_endereco` char(1) NOT NULL default '0',
  `observacoes2` longtext NOT NULL,
  `observacoes3` longtext NOT NULL,
  `ncoordenadas` varchar(100) NOT NULL default '',
  `calendario` int(1) NOT NULL default '0',
  `tipo_fianca` varchar(40) default NULL,
  PRIMARY KEY  (`cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `muraski_bkp17122018`
--

DROP TABLE IF EXISTS `muraski_bkp17122018`;
CREATE TABLE `muraski_bkp17122018` (
  `cod` int(11) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `ref` varchar(10) NOT NULL default '',
  `tipo` varchar(50) NOT NULL default '',
  `tipo_secundario` varchar(255) NOT NULL default '',
  `metragem` double(10,2) unsigned default NULL,
  `area_averbada` double(10,2) NOT NULL default '0.00',
  `area_terreno` double(10,2) NOT NULL default '0.00',
  `matricula_luz` int(11) NOT NULL default '0',
  `situacao_luz` int(1) NOT NULL default '0',
  `matricula_agua` int(11) NOT NULL default '0',
  `situacao_agua` int(1) NOT NULL default '0',
  `n_quartos` tinyint(3) unsigned default NULL,
  `valor` double(10,2) unsigned default NULL,
  `especificacao` varchar(10) default NULL,
  `suites` tinyint(3) unsigned default NULL,
  `caracteristica` varchar(100) NOT NULL default '',
  `piscina` varchar(7) default NULL,
  `titulo` text NOT NULL,
  `descricao` text NOT NULL,
  `img_peq` varchar(23) default NULL,
  `img_1` varchar(20) default NULL,
  `img_2` varchar(20) default NULL,
  `img_3` varchar(20) default NULL,
  `img_4` varchar(20) default NULL,
  `img_5` varchar(20) default NULL,
  `img_6` varchar(20) default NULL,
  `img_7` varchar(20) default NULL,
  `img_8` varchar(20) default NULL,
  `img_9` varchar(20) default NULL,
  `img_10` varchar(20) default NULL,
  `uf` int(2) NOT NULL default '0',
  `local` varchar(40) default NULL,
  `permuta` varchar(7) default NULL,
  `finalidade` varchar(50) NOT NULL default '',
  `permuta_txt` text,
  `ftxt_1` varchar(50) default NULL,
  `ftxt_2` varchar(50) default NULL,
  `ftxt_3` varchar(50) default NULL,
  `ftxt_4` varchar(50) default NULL,
  `ftxt_5` varchar(50) default NULL,
  `ftxt_6` varchar(50) default NULL,
  `ftxt_7` varchar(50) default NULL,
  `ftxt_8` varchar(50) default NULL,
  `ftxt_9` varchar(50) default NULL,
  `ftxt_10` varchar(50) default NULL,
  `ftxt_11` varchar(50) default NULL,
  `ftxt_12` varchar(50) default NULL,
  `ftxt_13` varchar(50) default NULL,
  `ftxt_14` varchar(50) default NULL,
  `ftxt_15` varchar(50) default NULL,
  `ftxt_16` varchar(50) default NULL,
  `ftxt_17` varchar(50) default NULL,
  `ftxt_18` varchar(50) default NULL,
  `ftxt_19` varchar(50) default NULL,
  `ftxt_20` varchar(50) default NULL,
  `cliente` varchar(100) NOT NULL default '',
  `percentual_prop` varchar(100) NOT NULL default '',
  `matricula` varchar(10) default NULL,
  `cidade_mat` varchar(40) default NULL,
  `cartorio_oficio` varchar(100) NOT NULL default '',
  `lote` varchar(10) NOT NULL default '',
  `quadra` varchar(10) NOT NULL default '',
  `planta` varchar(100) NOT NULL default '',
  `bairro` varchar(100) NOT NULL default '',
  `tipo_logradouro` varchar(10) NOT NULL default '',
  `end` varchar(200) default NULL,
  `numero` varchar(10) NOT NULL default '',
  `cep` varchar(10) NOT NULL default '',
  `averbacao` double(10,2) default NULL,
  `acomod` tinyint(2) NOT NULL default '0',
  `dist_mar` varchar(20) NOT NULL default '',
  `dist_tipo` varchar(40) default NULL,
  `limpeza` double(5,2) default NULL,
  `diaria1` double(10,2) default NULL,
  `diaria2` double(10,2) default NULL,
  `data_inicio` date default NULL,
  `data_fim` date default NULL,
  `datai_renova` date default NULL,
  `dataf_renova` date default NULL,
  `comissao` int(11) NOT NULL default '0',
  `dias` int(5) default NULL,
  `dias_plocacao` varchar(50) NOT NULL default '',
  `contrato` int(10) NOT NULL default '0',
  `renova_simnao` char(1) NOT NULL default '1',
  `opcao_simnao` char(1) NOT NULL default '0',
  `carnaval` double(10,2) default NULL,
  `anonovo` double(10,2) default NULL,
  `feriado` double(10,2) default NULL,
  `coordenadas` longtext NOT NULL,
  `posx` int(6) unsigned default NULL,
  `posy` int(6) unsigned default NULL,
  `tv` double(10,2) default NULL,
  `angariador` varchar(50) NOT NULL default '',
  `zelador` varchar(200) default NULL,
  `tipo_anga` varchar(50) NOT NULL default '',
  `indicador` int(10) NOT NULL default '0',
  `comissao_indicador` varchar(10) NOT NULL default '',
  `comissao_vendedor` varchar(10) NOT NULL default '',
  `diarista` int(10) NOT NULL default '0',
  `comissao_diarista` varchar(10) NOT NULL default '',
  `piscineiro` int(10) NOT NULL default '0',
  `comissao_piscineiro` varchar(10) NOT NULL default '',
  `eletricista` int(10) NOT NULL default '0',
  `comissao_eletricista` varchar(10) NOT NULL default '',
  `encanador` int(10) NOT NULL default '0',
  `comissao_encanador` varchar(10) NOT NULL default '',
  `jardineiro` int(10) NOT NULL default '0',
  `comissao_jardineiro` varchar(10) NOT NULL default '',
  `chaves` text,
  `controle_chave` int(10) NOT NULL default '0',
  `tipo_div` varchar(200) default NULL,
  `valor_oferta` double(20,2) default NULL,
  `relacao_bens` text NOT NULL,
  `data_bens` date default NULL,
  `observacoes` text NOT NULL,
  `disponibilizar` char(1) NOT NULL default '0',
  `disp_rede` char(1) NOT NULL default '0',
  `destaque` char(1) NOT NULL default '0',
  `destaque_padrao` char(1) default '0',
  `lancamento` char(1) default '0',
  `comissao_parceria` varchar(10) NOT NULL default '',
  `contador` char(2) NOT NULL default '',
  `status` char(1) NOT NULL default '0',
  `construtora` varchar(100) NOT NULL default '',
  `idade_imovel` varchar(5) NOT NULL default '',
  `condominio` varchar(100) NOT NULL default '0.00',
  `apto` varchar(10) NOT NULL default '',
  `end_igual` char(1) NOT NULL default '1',
  `end_aproximado` char(1) default '0',
  `tipo_logradouro_mapa` varchar(10) NOT NULL default '',
  `end_mapa` varchar(200) NOT NULL default '',
  `numero_mapa` varchar(10) NOT NULL default '',
  `cep_mapa` varchar(10) default NULL,
  `video` varchar(50) default NULL,
  `origem_video` varchar(25) default NULL,
  `endereco_contrato` longtext NOT NULL,
  `exibir_endereco` char(1) NOT NULL default '0',
  `observacoes2` longtext NOT NULL,
  `observacoes3` longtext NOT NULL,
  `ncoordenadas` varchar(100) NOT NULL default '',
  `calendario` int(1) NOT NULL default '0',
  `tipo_fianca` varchar(40) default NULL,
  PRIMARY KEY  (`cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `ordem`
--

DROP TABLE IF EXISTS `ordem`;
CREATE TABLE `ordem` (
  `cod_o` int(2) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `tipo_o` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`cod_o`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `propostas`
--

DROP TABLE IF EXISTS `propostas`;
CREATE TABLE `propostas` (
  `id_proposta` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `cod_imovel` int(10) NOT NULL default '0',
  `cod_cliente` int(10) NOT NULL default '0',
  `data_proposta` date NOT NULL default '0000-00-00',
  `texto_proposta` longtext collate latin1_general_ci NOT NULL,
  `status_proposta` varchar(20) collate latin1_general_ci NOT NULL default '',
  `aceitacao` char(1) collate latin1_general_ci NOT NULL default '0',
  `p_user` int(10) NOT NULL default '0',
  `p_status` char(1) collate latin1_general_ci NOT NULL default 'A',
  PRIMARY KEY  (`id_proposta`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `rebri_bairros`
--

DROP TABLE IF EXISTS `rebri_bairros`;
CREATE TABLE `rebri_bairros` (
  `b_cod` int(11) NOT NULL auto_increment,
  `b_cidade` int(11) NOT NULL default '0',
  `b_nome` varchar(50) NOT NULL default '',
  `b_loja` char(1) default NULL,
  PRIMARY KEY  (`b_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_banners`
--

DROP TABLE IF EXISTS `rebri_banners`;
CREATE TABLE `rebri_banners` (
  `b_cod` int(11) NOT NULL auto_increment,
  `b_nome` varchar(100) NOT NULL default '',
  `b_chave` text,
  `b_ordem` int(11) NOT NULL default '0',
  `b_img` varchar(100) NOT NULL default '',
  `b_link` varchar(100) NOT NULL default '',
  `b_views` int(11) NOT NULL default '0',
  `b_clicks` int(11) NOT NULL default '0',
  `b_data` date NOT NULL default '0000-00-00',
  `b_data2` date NOT NULL default '0000-00-00',
  `b_setor` varchar(20) default NULL,
  `b_width` int(3) default NULL,
  `b_height` int(3) default NULL,
  PRIMARY KEY  (`b_cod`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_buscas`
--

DROP TABLE IF EXISTS `rebri_buscas`;
CREATE TABLE `rebri_buscas` (
  `rb_cod` int(11) NOT NULL auto_increment,
  `rb_finalidade` varchar(100) default NULL,
  `rb_estado` varchar(150) default NULL,
  `rb_cidade` varchar(200) default NULL,
  `rb_tipo_im` varchar(100) default NULL,
  `rb_n_quartos` varchar(50) default NULL,
  `rb_referencia` varchar(20) default NULL,
  `rb_endereco` text,
  `rb_valor` varchar(200) default NULL,
  `rb_im_estado` varchar(150) default NULL,
  `rb_im_cidade` varchar(200) default NULL,
  `rb_im_nome` varchar(200) default NULL,
  PRIMARY KEY  (`rb_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_caracteristicas`
--

DROP TABLE IF EXISTS `rebri_caracteristicas`;
CREATE TABLE `rebri_caracteristicas` (
  `c_cod` int(11) NOT NULL auto_increment,
  `c_nome` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`c_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_cidades`
--

DROP TABLE IF EXISTS `rebri_cidades`;
CREATE TABLE `rebri_cidades` (
  `ci_cod` int(4) NOT NULL auto_increment,
  `ci_estado` int(4) NOT NULL default '0',
  `ci_uf` varchar(4) NOT NULL default '',
  `ci_nome` varchar(50) NOT NULL default '',
  `ci_litoranea` char(2) NOT NULL default '0',
  UNIQUE KEY `ci_cod` (`ci_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_clientes_site`
--

DROP TABLE IF EXISTS `rebri_clientes_site`;
CREATE TABLE `rebri_clientes_site` (
  `cs_cod` int(5) NOT NULL auto_increment,
  `cs_nome` varchar(150) NOT NULL default '',
  `cs_cpf` varchar(20) NOT NULL default '',
  `cs_nasc` date NOT NULL default '0000-00-00',
  `cs_tel` varchar(50) NOT NULL default '',
  `cs_cel` varchar(50) default NULL,
  `cs_email` varchar(200) NOT NULL default '',
  `cs_cep` varchar(8) NOT NULL default '',
  `cs_end` varchar(150) NOT NULL default '',
  `cs_bairro` varchar(50) NOT NULL default '',
  `cs_cidade` varchar(100) NOT NULL default '',
  `cs_estado` char(2) NOT NULL default '',
  `cs_pais` varchar(50) NOT NULL default '',
  `cs_senha` varchar(6) NOT NULL default '',
  PRIMARY KEY  (`cs_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_destaques`
--

DROP TABLE IF EXISTS `rebri_destaques`;
CREATE TABLE `rebri_destaques` (
  `d_cod` int(11) NOT NULL auto_increment,
  `d_qtd` int(11) NOT NULL default '0',
  `d_tipo` varchar(20) default NULL,
  PRIMARY KEY  (`d_cod`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_estados`
--

DROP TABLE IF EXISTS `rebri_estados`;
CREATE TABLE `rebri_estados` (
  `e_cod` tinyint(4) NOT NULL auto_increment,
  `e_uf` varchar(10) NOT NULL default '',
  `e_nome` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`e_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_imagens`
--

DROP TABLE IF EXISTS `rebri_imagens`;
CREATE TABLE `rebri_imagens` (
  `img_cod` int(11) NOT NULL auto_increment,
  `img_imob` int(11) NOT NULL default '0',
  `img_imovel` int(11) NOT NULL default '0',
  `img_nome` varchar(100) default NULL,
  `img_arq` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`img_cod`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_imobiliarias`
--

DROP TABLE IF EXISTS `rebri_imobiliarias`;
CREATE TABLE `rebri_imobiliarias` (
  `im_cod` int(11) NOT NULL auto_increment,
  `im_nome` varchar(150) NOT NULL default '',
  `im_contato` varchar(100) NOT NULL default '',
  `im_resp` varchar(100) default NULL,
  `im_creci_resp` varchar(30) default NULL,
  `im_nacionalidade` varchar(50) NOT NULL default '',
  `im_est_civil` varchar(30) NOT NULL default '',
  `im_n_conselho` varchar(30) NOT NULL default '',
  `im_razao` varchar(100) NOT NULL default '',
  `im_cnpj` varchar(20) NOT NULL default '',
  `im_banco` varchar(100) NOT NULL default '',
  `im_agencia` varchar(30) NOT NULL default '',
  `im_conta` varchar(30) NOT NULL default '',
  `im_tel` varchar(20) NOT NULL default '',
  `im_fax` varchar(20) NOT NULL default '',
  `im_cel` varchar(20) NOT NULL default '',
  `im_end` varchar(150) NOT NULL default '',
  `im_end2` varchar(150) NOT NULL default '',
  `iend_igual` char(1) default '1',
  `im_end_mapa` varchar(150) default NULL,
  `end_igual2` char(1) default '1',
  `im_end_mapa2` varchar(150) default NULL,
  `im_bairro2` varchar(50) NOT NULL default '',
  `im_cep2` varchar(8) NOT NULL default '',
  `im_tel2` varchar(20) NOT NULL default '',
  `im_email2` varchar(150) NOT NULL default '',
  `im_bairro` varchar(50) NOT NULL default '',
  `im_cidade` varchar(100) NOT NULL default '',
  `im_estado` char(2) NOT NULL default '',
  `im_cep` varchar(8) NOT NULL default '',
  `im_email` varchar(150) NOT NULL default '',
  `im_senha` varchar(30) NOT NULL default '',
  `im_img` varchar(50) default NULL,
  `im_desc` text,
  `im_desde` date NOT NULL default '0000-00-00',
  `nome_pasta` varchar(20) NOT NULL default '',
  `comissao_angariador` varchar(10) NOT NULL default '',
  `comissao_vendedor` varchar(10) NOT NULL default '',
  `comissao_indicador` varchar(10) NOT NULL default '',
  `contrato_venda` int(10) NOT NULL default '0',
  `contrato_locacao` int(10) NOT NULL default '0',
  `contrato_locacao_anual` int(10) NOT NULL default '0',
  `comissao_imobiliaria_venda` varchar(10) default NULL,
  `comissao_angariador_loc_anual` varchar(10) default NULL,
  `comissao_vendedor_loc_anual` varchar(10) default NULL,
  `comissao_indicador_loc_anual` varchar(10) default NULL,
  `comissao_imobiliaria_loc_anual` varchar(10) default NULL,
  `taxa_mensal` varchar(10) default NULL,
  `comissao_imobiliaria_loc_temp` varchar(10) default NULL,
  `im_site` varchar(100) default NULL,
  `im_site2` varchar(200) NOT NULL default '',
  `im_site_padrao` char(1) NOT NULL default '',
  `im_disponibilizar` char(1) NOT NULL default '0',
  `im_desativar` char(1) NOT NULL default '0',
  `im_clicks` int(11) default NULL,
  `im_site_institucional` text NOT NULL,
  `im_site_fundo` varchar(6) NOT NULL default '',
  `im_site_titulo_lateral` varchar(6) NOT NULL default '',
  `im_site_rodape` varchar(6) NOT NULL default '',
  `im_site_titulo_interno` varchar(6) NOT NULL default '',
  `im_site_referencia_interna` varchar(6) NOT NULL default '',
  `im_site_resumo` varchar(6) NOT NULL default '',
  `im_tolera` char(2) default NULL,
  PRIMARY KEY  (`im_cod`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_imoveis`
--

DROP TABLE IF EXISTS `rebri_imoveis`;
CREATE TABLE `rebri_imoveis` (
  `i_cod` int(11) NOT NULL auto_increment,
  `i_ref` varchar(10) NOT NULL default '',
  `i_tipo` varchar(11) NOT NULL default '',
  `i_metragem` double(10,2) default NULL,
  `i_n_quartos` tinyint(3) unsigned default NULL,
  `i_valor` double(20,2) unsigned default NULL,
  `i_suites` tinyint(3) unsigned default NULL,
  `i_titulo` varchar(26) default NULL,
  `i_titulo2` varchar(26) default NULL,
  `i_descricao` text,
  `i_finalidade` varchar(10) NOT NULL default '',
  `i_acomod` int(2) default NULL,
  `i_imob` int(4) NOT NULL default '0',
  `i_data` datetime NOT NULL default '0000-00-00 00:00:00',
  `i_destaque` char(3) NOT NULL default '',
  `i_cidade` varchar(150) NOT NULL default '',
  `i_estado` char(2) NOT NULL default '',
  `i_especificacao` varchar(15) NOT NULL default '',
  `i_piscina` char(3) NOT NULL default 'Não',
  `i_permuta` char(3) NOT NULL default 'Não',
  `i_permuta_txt` text,
  `i_end` varchar(200) default NULL,
  `i_carnaval` double(20,2) default NULL,
  `i_anonovo` double(20,2) default NULL,
  PRIMARY KEY  (`i_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 PACK_KEYS=1;

--
-- Table structure for table `rebri_imoveis_temp`
--

DROP TABLE IF EXISTS `rebri_imoveis_temp`;
CREATE TABLE `rebri_imoveis_temp` (
  `sid` varchar(200) NOT NULL default '',
  `i_cod` varchar(50) NOT NULL default '',
  `p_data` date NOT NULL default '0000-00-00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_listas`
--

DROP TABLE IF EXISTS `rebri_listas`;
CREATE TABLE `rebri_listas` (
  `l_cod` int(5) unsigned NOT NULL auto_increment,
  `l_sid` varchar(200) NOT NULL default '',
  `l_cliente` varchar(20) NOT NULL default '',
  `l_data` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`l_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_noticias`
--

DROP TABLE IF EXISTS `rebri_noticias`;
CREATE TABLE `rebri_noticias` (
  `n_cod` int(5) NOT NULL auto_increment,
  `n_tipo` varchar(50) NOT NULL default '',
  `n_grupo` varchar(50) NOT NULL default '',
  `n_nome` varchar(250) NOT NULL default '',
  `n_txt` text,
  `n_data` date NOT NULL default '0000-00-00',
  `n_autor` varchar(100) NOT NULL default '',
  `n_html` char(3) NOT NULL default 'Nao',
  PRIMARY KEY  (`n_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_rebri_cidades`
--

DROP TABLE IF EXISTS `rebri_rebri_cidades`;
CREATE TABLE `rebri_rebri_cidades` (
  `ci_cod` int(4) NOT NULL auto_increment,
  `ci_estado` int(4) NOT NULL default '0',
  `ci_uf` varchar(4) NOT NULL default '',
  `ci_nome` varchar(50) NOT NULL default '',
  UNIQUE KEY `ci_cod` (`ci_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_rebri_imagens`
--

DROP TABLE IF EXISTS `rebri_rebri_imagens`;
CREATE TABLE `rebri_rebri_imagens` (
  `img_cod` int(11) NOT NULL auto_increment,
  `img_imob` int(11) NOT NULL default '0',
  `img_imovel` int(11) NOT NULL default '0',
  `img_nome` varchar(100) default NULL,
  `img_arq` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`img_cod`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_rebri_imoveis_temp`
--

DROP TABLE IF EXISTS `rebri_rebri_imoveis_temp`;
CREATE TABLE `rebri_rebri_imoveis_temp` (
  `sid` varchar(200) NOT NULL default '',
  `i_cod` varchar(50) NOT NULL default '',
  `p_data` date NOT NULL default '0000-00-00'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_rebri_stats`
--

DROP TABLE IF EXISTS `rebri_rebri_stats`;
CREATE TABLE `rebri_rebri_stats` (
  `s_cod` bigint(20) unsigned NOT NULL auto_increment,
  `s_imovel` int(10) unsigned NOT NULL default '0',
  `s_imob` int(10) unsigned NOT NULL default '0',
  `s_data` date NOT NULL default '0000-00-00',
  `s_qtd` bigint(20) NOT NULL default '0',
  `s_tipo` varchar(20) default NULL,
  PRIMARY KEY  (`s_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_stats`
--

DROP TABLE IF EXISTS `rebri_stats`;
CREATE TABLE `rebri_stats` (
  `s_cod` bigint(20) unsigned NOT NULL auto_increment,
  `s_imovel` int(10) unsigned NOT NULL default '0',
  `s_imob` int(10) unsigned NOT NULL default '0',
  `s_data` date NOT NULL default '0000-00-00',
  `s_qtd` bigint(20) NOT NULL default '0',
  `s_tipo` varchar(20) default NULL,
  PRIMARY KEY  (`s_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_tipo`
--

DROP TABLE IF EXISTS `rebri_tipo`;
CREATE TABLE `rebri_tipo` (
  `t_cod` int(5) unsigned NOT NULL auto_increment,
  `t_nome` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`t_cod`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_tipo_anuncios`
--

DROP TABLE IF EXISTS `rebri_tipo_anuncios`;
CREATE TABLE `rebri_tipo_anuncios` (
  `ta_cod` int(2) NOT NULL auto_increment,
  `ta_nome` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`ta_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_tipo_comercio`
--

DROP TABLE IF EXISTS `rebri_tipo_comercio`;
CREATE TABLE `rebri_tipo_comercio` (
  `tc_cod` int(10) NOT NULL auto_increment,
  `tc_nome` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`tc_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_tipo_old`
--

DROP TABLE IF EXISTS `rebri_tipo_old`;
CREATE TABLE `rebri_tipo_old` (
  `t_cod` int(5) unsigned NOT NULL auto_increment,
  `t_nome` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`t_cod`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `rebri_usuarios`
--

DROP TABLE IF EXISTS `rebri_usuarios`;
CREATE TABLE `rebri_usuarios` (
  `u_cod` tinyint(3) unsigned NOT NULL auto_increment,
  `u_nome` varchar(200) NOT NULL default '',
  `u_email` varchar(200) NOT NULL default '',
  `u_senha` varchar(50) NOT NULL default '',
  `u_tipo` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`u_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `recibo_imobiliaria`
--

DROP TABLE IF EXISTS `recibo_imobiliaria`;
CREATE TABLE `recibo_imobiliaria` (
  `id_recibo` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `cod_cliente` int(10) NOT NULL default '0',
  `valor_recibo` decimal(10,2) NOT NULL default '0.00',
  `data_recibo` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`id_recibo`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `recibo_prestador`
--

DROP TABLE IF EXISTS `recibo_prestador`;
CREATE TABLE `recibo_prestador` (
  `id_recibo` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `cod_cliente` int(10) NOT NULL default '0',
  `valor_recibo` decimal(10,2) NOT NULL default '0.00',
  `referente` longtext NOT NULL,
  `data_recibo` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`id_recibo`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `rel_area_usuario`
--

DROP TABLE IF EXISTS `rel_area_usuario`;
CREATE TABLE `rel_area_usuario` (
  `area_id` int(10) unsigned NOT NULL default '0',
  `u_cod` int(10) unsigned NOT NULL default '0',
  `cod_imobiliaria` int(10) NOT NULL default '0',
  PRIMARY KEY  (`area_id`,`u_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `remessa`
--

DROP TABLE IF EXISTS `remessa`;
CREATE TABLE `remessa` (
  `codigo` int(10) NOT NULL auto_increment,
  `sacado` varchar(255) NOT NULL default '',
  `nrdoc` varchar(11) NOT NULL default '',
  `dt_vcto` date NOT NULL default '0000-00-00',
  `valor` double NOT NULL default '0',
  `cpf` varchar(14) NOT NULL default '',
  `end` varchar(50) NOT NULL default '',
  `bairro` varchar(50) NOT NULL default '',
  `cidade` varchar(50) NOT NULL default '',
  `uf` char(2) NOT NULL default '',
  `cep` varchar(9) NOT NULL default '',
  `inst2` varchar(255) NOT NULL default '',
  `inst3` varchar(255) NOT NULL default '',
  `inst4` varchar(255) NOT NULL default '',
  `url_remessa` varchar(255) NOT NULL default '',
  `status` varchar(7) default NULL,
  `loc_deletada` char(1) NOT NULL default 'N',
  `rem_baixada` char(1) NOT NULL default 'N',
  `dt_baixa` date NOT NULL default '0000-00-00',
  `dt_pgto` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`codigo`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `senha_web`
--

DROP TABLE IF EXISTS `senha_web`;
CREATE TABLE `senha_web` (
  `s_cod` int(1) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `s_senha` char(6) NOT NULL default '',
  PRIMARY KEY  (`s_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `servicos`
--

DROP TABLE IF EXISTS `servicos`;
CREATE TABLE `servicos` (
  `id_servico` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `cod_imovel` int(10) NOT NULL default '0',
  `nome_servico` varchar(100) NOT NULL default '',
  `data_servico` date NOT NULL default '0000-00-00',
  `valor_servico` double(10,2) NOT NULL default '0.00',
  `situacao` varchar(30) NOT NULL default '',
  `locacao` int(10) NOT NULL default '0',
  `impressao` char(1) NOT NULL default '0',
  PRIMARY KEY  (`id_servico`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `sinal_venda`
--

DROP TABLE IF EXISTS `sinal_venda`;
CREATE TABLE `sinal_venda` (
  `id_sinal` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `cod_imovel` int(10) NOT NULL default '0',
  `cod_cliente` int(10) NOT NULL default '0',
  `texto_sinal` longtext collate latin1_general_ci NOT NULL,
  `data_sinal` date NOT NULL default '0000-00-00',
  `valor_venda` double(10,2) NOT NULL default '0.00',
  `vendedor` int(10) NOT NULL default '0',
  `status_sinal` varchar(30) collate latin1_general_ci NOT NULL default '',
  `s_status` char(1) collate latin1_general_ci NOT NULL default 'A',
  PRIMARY KEY  (`id_sinal`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `solicitacao_servicos`
--

DROP TABLE IF EXISTS `solicitacao_servicos`;
CREATE TABLE `solicitacao_servicos` (
  `id_servico` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `cod_imovel` int(10) NOT NULL default '0',
  `tipo_prestador` varchar(20) collate latin1_general_ci NOT NULL default '',
  `cod_prestador` int(10) NOT NULL default '0',
  `data_servico` date NOT NULL default '0000-00-00',
  `valor_servico` double(10,2) NOT NULL default '0.00',
  `comentario` longtext collate latin1_general_ci NOT NULL,
  `status` varchar(20) collate latin1_general_ci NOT NULL default '',
  `data_pagamento` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`id_servico`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `tipo_contas`
--

DROP TABLE IF EXISTS `tipo_contas`;
CREATE TABLE `tipo_contas` (
  `t_cod` int(11) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `t_nome` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`t_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `tipo_servico`
--

DROP TABLE IF EXISTS `tipo_servico`;
CREATE TABLE `tipo_servico` (
  `id_servico` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `nome_servico` varchar(100) NOT NULL default '',
  `valor_servico` double(10,2) NOT NULL default '0.00',
  `situacao` char(2) NOT NULL default '00',
  PRIMARY KEY  (`id_servico`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `tipos_clientes`
--

DROP TABLE IF EXISTS `tipos_clientes`;
CREATE TABLE `tipos_clientes` (
  `tc_cod` int(11) NOT NULL auto_increment,
  `tc_tipo` varchar(50) NOT NULL default '',
  `tc_icone` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`tc_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `tipos_prestadores`
--

DROP TABLE IF EXISTS `tipos_prestadores`;
CREATE TABLE `tipos_prestadores` (
  `tp_cod` int(11) NOT NULL auto_increment,
  `tp_tipo` varchar(50) NOT NULL default '',
  `tp_icone` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`tp_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `usuarios`
--

DROP TABLE IF EXISTS `usuarios`;
CREATE TABLE `usuarios` (
  `u_cod` int(2) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `u_nome` varchar(200) NOT NULL default '',
  `u_email` varchar(200) NOT NULL default '',
  `u_senha` varchar(32) NOT NULL default '',
  `u_tipo` varchar(20) NOT NULL default '',
  `u_status` varchar(20) NOT NULL default '',
  `u_foto` varchar(20) NOT NULL default '',
  `u_cookie` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`u_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `vbooth_data`
--

DROP TABLE IF EXISTS `vbooth_data`;
CREATE TABLE `vbooth_data` (
  `pollID` int(11) NOT NULL default '0',
  `optionText` char(50) NOT NULL default '',
  `optionCount` int(11) NOT NULL default '0',
  `voteID` int(11) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `vbooth_desc`
--

DROP TABLE IF EXISTS `vbooth_desc`;
CREATE TABLE `vbooth_desc` (
  `pollID` int(11) NOT NULL auto_increment,
  `pollTitle` char(100) NOT NULL default '',
  `timeStamp` int(11) NOT NULL default '0',
  PRIMARY KEY  (`pollID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `vbooth_ip`
--

DROP TABLE IF EXISTS `vbooth_ip`;
CREATE TABLE `vbooth_ip` (
  `pollID` int(11) NOT NULL default '0',
  `voteID` int(11) NOT NULL default '0',
  `votersIP` char(16) NOT NULL default '',
  `timeStamp` int(11) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `vbooth_log`
--

DROP TABLE IF EXISTS `vbooth_log`;
CREATE TABLE `vbooth_log` (
  `logID` int(11) NOT NULL auto_increment,
  `pollID` int(11) NOT NULL default '0',
  `voteID` int(11) NOT NULL default '0',
  `votersIP` char(16) NOT NULL default '',
  `timeStamp` int(11) NOT NULL default '0',
  PRIMARY KEY  (`logID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `veiculos_inquilino`
--

DROP TABLE IF EXISTS `veiculos_inquilino`;
CREATE TABLE `veiculos_inquilino` (
  `id_veiculo` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `id_inquilino` int(10) NOT NULL default '0',
  `veiculo_inquilino` varchar(100) collate latin1_general_ci NOT NULL default '',
  `cor_inquilino` varchar(50) collate latin1_general_ci NOT NULL default '',
  `placa_inquilino` varchar(30) collate latin1_general_ci NOT NULL default '',
  `cidade_veiculo_inquilino` varchar(150) collate latin1_general_ci NOT NULL default '',
  PRIMARY KEY  (`id_veiculo`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Table structure for table `vendas`
--

DROP TABLE IF EXISTS `vendas`;
CREATE TABLE `vendas` (
  `v_cod` int(10) NOT NULL auto_increment,
  `cod_imobiliaria` int(10) NOT NULL default '0',
  `v_cliente` int(5) NOT NULL default '0',
  `v_imovel` varchar(10) collate latin1_general_ci NOT NULL default '',
  `v_total` double(10,2) NOT NULL default '0.00',
  `v_pagto` text collate latin1_general_ci,
  `v_comissao` double(10,2) default NULL,
  `v_saldo` double(10,2) default NULL,
  `v_data` date default NULL,
  `v_usuario` varchar(100) collate latin1_general_ci default NULL,
  `v_status` char(1) collate latin1_general_ci NOT NULL default 'A',
  PRIMARY KEY  (`v_cod`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

